/*:
 * @target MZ
 * @plugindesc 装備画面で装備スロット選択中に Shift キーで装備解除（Unequip）できます。
 * @author you + ChatGPT
 * @url https://example.com
 *
 * @help ShiftUnequipOnEquipSlot.js
 *
 * 【概要】
 * 装備シーン(Scene_Equip)で装備スロット側のウィンドウがアクティブな間、
 * Shift キーを押すだけで、選択中のスロットの装備を外します。
 *
 * 【使い方】
 * 1) 本ファイルを ShiftUnequipOnEquipSlot.js として保存し、
 *    プロジェクトの js/plugins フォルダに配置します。
 * 2) プラグイン管理で本プラグインを有効化してください。
 *
 * 【仕様】
 * - 対象は装備スロットウィンドウ(Window_EquipSlot)がアクティブな時のみ。
 * - 何も装備していないスロットで Shift を押すとブザー音が鳴ります。
 * - 装備解除時は決定音（装備音）が鳴ります。
 * - 他プラグインとの競合を避けるため、元メソッドをエイリアスして拡張しています。
 *
 * このプラグインにはプラグインコマンドやパラメータはありません。
 */

(() => {
  'use strict';

  // --- Window_EquipSlot: Shift検知を追加 ---
  const _Window_EquipSlot_update = Window_EquipSlot.prototype.update;
  Window_EquipSlot.prototype.update = function() {
    _Window_EquipSlot_update.call(this);
    if (this.isOpenAndActive() && Input.isTriggered('shift')) {
      if (this.isHandled('unequip')) {
        this.callHandler('unequip');
      }
    }
  };

  // --- Scene_Equip: ハンドラ登録＆処理 ---
  const _Scene_Equip_createSlotWindow = Scene_Equip.prototype.createSlotWindow;
  Scene_Equip.prototype.createSlotWindow = function() {
    _Scene_Equip_createSlotWindow.call(this);
    // Shiftによる装備解除用ハンドラを登録
    this._slotWindow.setHandler('unequip', this.onSlotShiftUnequip.bind(this));
  };

  Scene_Equip.prototype.onSlotShiftUnequip = function() {
    const index = this._slotWindow.index();
    const actor = this.actor();
    if (!actor) return;

    // 現在スロットのアイテム（装備）を取得
    const currentItem = this._slotWindow.item();
    if (currentItem) {
      // 装備を外す
      actor.changeEquip(index, null);
      SoundManager.playEquip();
      // 表示更新
      this._slotWindow.refresh();
      if (this._itemWindow) this._itemWindow.refresh();
      if (this._statusWindow) this._statusWindow.refresh();
    } else {
      SoundManager.playBuzzer();
    }
  };
})();
